﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
''' <summary>
'''封装自定义安全性的授权部分。
''' </summary>
''' <remarks></remarks>
Public Class SampleIPrincipal : Implements System.Security.Principal.IPrincipal

    ''' <summary>
    '''与此主体关联的标识
    ''' </summary>
    ''' <remarks></remarks>
    Private identityValue As System.Security.Principal.IIdentity

    ''' <summary>
    '''在给定用户名和密码的情况下创建一个新的 SamplePrincipal
    ''' </summary>
    ''' <param name="name">为 SampleIdentity 提供的用户名</param>
    ''' <param name="password">为 SampleIdentity 提供的密码</param>
    ''' <remarks></remarks>
    Public Sub New(ByVal name As String, ByVal password As String)
        identityValue = New SampleIIdentity(name, password)
    End Sub

    ''' <summary>
    '''返回此用户的标识
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    Public ReadOnly Property Identity() As System.Security.Principal.IIdentity Implements System.Security.Principal.IPrincipal.Identity
        Get
            Return identityValue
        End Get
    End Property

    ''' <summary>
    '''确定当前用户的角色。
    ''' </summary>
    ''' <param name="role">传递“DemoUser”将返回 true；否则返回 false。</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function IsInRole(ByVal role As String) As Boolean Implements System.Security.Principal.IPrincipal.IsInRole
        If (role.Equals("DemoUser")) Then
            Return True
        Else
            Return False
        End If
    End Function
End Class



